DROP PROCEDURE [hips].[HL7MessageLogDelete]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon
-- Create date: 25 July 2012
-- Description:   Deletes an existing record from the Message Table
-- =============================================
CREATE PROCEDURE [hips].[HL7MessageLogDelete]
(
@HL7MessageLogId INT
)
AS
BEGIN
SET NOCOUNT ON
DECLARE @intErrorCode INT,
@intRowsAffected INT
SELECT  @intErrorCode = 0,
@intRowsAffected = 0
DELETE
 [hips].[HL7MessageLog]
WHERE [HL7MessageLogId] = @HL7MessageLogId
SELECT @intErrorCode = @@ERROR,
@intRowsAffected = @@ROWCOUNT
SELECT @intRowsAffected AS RowsAffected
RETURN(@intErrorCode)
END
GO

